CREATE DATABASE  IF NOT EXISTS `labdata` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `labdata`;
-- MySQL dump 10.13  Distrib 5.6.13, for Win32 (x86)
--
-- Host: localhost    Database: labdata
-- ------------------------------------------------------
-- Server version	5.6.15

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `call_messages`
--

DROP TABLE IF EXISTS `call_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `call_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientTestId` int(11) NOT NULL,
  `operatorId` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '0 = PENDING\n1 = CALL (LabCaller speaks message, sets status=2)\n2 = CALLED (elleapsed timer starts counting)\n3 = DISCARDED (sets index to last ID + 1, moves back in queue)',
  `eleapsed` int(11) NOT NULL DEFAULT '0' COMMENT 'Eleapsed since since status = 2',
  `callCount` int(11) NOT NULL DEFAULT '0' COMMENT 'Number of times status has been set to "1"',
  `index` int(11) NOT NULL DEFAULT '0' COMMENT 'Order ID when discarded',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_call_messages_clients_tests1_idx` (`clientTestId`),
  KEY `fk_call_messages_operators1_idx` (`operatorId`),
  CONSTRAINT `fk_call_messages_clients_tests1` FOREIGN KEY (`clientTestId`) REFERENCES `clients_tests` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_call_messages_operators1` FOREIGN KEY (`operatorId`) REFERENCES `operators` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3311 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `clients`
--

DROP TABLE IF EXISTS `clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(36) NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9668 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `clients_labels`
--

DROP TABLE IF EXISTS `clients_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clients_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientId` int(11) NOT NULL,
  `labelId` int(11) NOT NULL,
  `value` varchar(250) DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_clients_labels_clients1_idx` (`clientId`),
  KEY `fk_clients_labels_labels1_idx` (`labelId`),
  CONSTRAINT `fk_clients_labels_clients1` FOREIGN KEY (`clientId`) REFERENCES `clients` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_clients_labels_labels1` FOREIGN KEY (`labelId`) REFERENCES `labels` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=91452 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `clients_tests`
--

DROP TABLE IF EXISTS `clients_tests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clients_tests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientId` int(11) NOT NULL,
  `operatorId` int(11) NOT NULL,
  `testDate` datetime NOT NULL,
  `total` float(10,4) DEFAULT '0.0000',
  `doctorName` text,
  `notes` text,
  `record` text,
  `receiptNumber` int(11) DEFAULT '0',
  `state` bit(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_clients_tests_clients1_idx` (`clientId`),
  KEY `fk_clients_tests_operators1_idx` (`operatorId`),
  KEY `fk_clients_tests_record` (`record`(32)),
  KEY `receiptNumber_idx` (`receiptNumber`),
  CONSTRAINT `fk_clients_tests_clients1` FOREIGN KEY (`clientId`) REFERENCES `clients` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_clients_tests_operators1` FOREIGN KEY (`operatorId`) REFERENCES `operators` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=11629 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `forms`
--

DROP TABLE IF EXISTS `forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT '',
  `description` varchar(250) DEFAULT '',
  `data` longblob,
  `categoryId` int(11) NOT NULL,
  `guid` varchar(36) NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  `active` bit(1) NOT NULL DEFAULT b'1',
  `operatorId` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_forms_forms_categories_idx` (`categoryId`),
  KEY `fk_forms_operators1_idx` (`operatorId`),
  CONSTRAINT `fk_forms_forms_categories` FOREIGN KEY (`categoryId`) REFERENCES `forms_categories` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_forms_operators1` FOREIGN KEY (`operatorId`) REFERENCES `operators` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `forms_categories`
--

DROP TABLE IF EXISTS `forms_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `forms_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `label_types`
--

DROP TABLE IF EXISTS `label_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `label_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT '',
  `isSystemType` bit(1) NOT NULL DEFAULT b'0',
  `guid` varchar(36) NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_label_types_misc` (`name`,`guid`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `labels`
--

DROP TABLE IF EXISTS `labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT '<New Name>',
  `guid` varchar(36) NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  `typeId` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_labels_label_types1_idx` (`typeId`),
  KEY `fk_labels_misc` (`name`,`typeId`,`guid`),
  CONSTRAINT `fk_labels_label_types1` FOREIGN KEY (`typeId`) REFERENCES `label_types` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `op_privileges_frm_categories`
--

DROP TABLE IF EXISTS `op_privileges_frm_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `op_privileges_frm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `categoryId` int(11) NOT NULL,
  `privilegeId` int(11) NOT NULL,
  `operatorTypeId` int(11) NOT NULL,
  `value` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_op_privileges_frm_categories_forms_categories1_idx` (`categoryId`),
  KEY `fk_op_privileges_frm_categories_operators_privileges1_idx` (`privilegeId`),
  KEY `fk_op_privileges_frm_categories_operators_types1_idx` (`operatorTypeId`),
  CONSTRAINT `fk_op_privileges_frm_categories_forms_categories1` FOREIGN KEY (`categoryId`) REFERENCES `forms_categories` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_op_privileges_frm_categories_operators_privileges1` FOREIGN KEY (`privilegeId`) REFERENCES `operators_privileges` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_op_privileges_frm_categories_operators_types1` FOREIGN KEY (`operatorTypeId`) REFERENCES `operators_types` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `operators`
--

DROP TABLE IF EXISTS `operators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `operatorTypeId` int(11) NOT NULL,
  `guid` varchar(36) NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  `active` bit(1) DEFAULT b'1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_operators_operators_types1_idx` (`operatorTypeId`),
  CONSTRAINT `fk_operators_operators_types1` FOREIGN KEY (`operatorTypeId`) REFERENCES `operators_types` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `operators_labels`
--

DROP TABLE IF EXISTS `operators_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operators_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labelId` int(11) NOT NULL,
  `operatorId` int(11) NOT NULL,
  `value` varchar(250) DEFAULT '<New Value>',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_operators_labels_operators1_idx` (`operatorId`),
  KEY `fk_operators_labels_labels1_idx` (`labelId`),
  CONSTRAINT `fk_operators_labels_labels1` FOREIGN KEY (`labelId`) REFERENCES `labels` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_operators_labels_operators1` FOREIGN KEY (`operatorId`) REFERENCES `operators` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `operators_privileges`
--

DROP TABLE IF EXISTS `operators_privileges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operators_privileges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT '',
  `guid` varchar(36) NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `operators_types`
--

DROP TABLE IF EXISTS `operators_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operators_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(45) DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `results`
--

DROP TABLE IF EXISTS `results`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `testId` int(11) NOT NULL,
  `testFormId` int(11) NOT NULL,
  `resultName` varchar(255) DEFAULT NULL,
  `resultUnit` varchar(255) DEFAULT NULL,
  `resultValue` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_results_tests1_idx` (`testId`),
  KEY `fk_results_tests_forms1_idx` (`testFormId`),
  CONSTRAINT `fk_results_tests1` FOREIGN KEY (`testId`) REFERENCES `tests` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_results_tests_forms1` FOREIGN KEY (`testFormId`) REFERENCES `tests_forms` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=47204 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tests`
--

DROP TABLE IF EXISTS `tests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `testGuid` varchar(36) NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000',
  `clientTestId` int(11) NOT NULL,
  `cost` float NOT NULL DEFAULT '0',
  `formId` int(11) NOT NULL,
  `priority` int(11) DEFAULT '0',
  `testName` varchar(128) DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_tests_forms1_idx` (`formId`),
  KEY `fk_tests_clients_tests1_idx` (`clientTestId`),
  CONSTRAINT `fk_tests_clients_tests1` FOREIGN KEY (`clientTestId`) REFERENCES `clients_tests` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tests_forms1` FOREIGN KEY (`formId`) REFERENCES `forms` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=21710 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tests_forms`
--

DROP TABLE IF EXISTS `tests_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tests_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientTestId` int(11) NOT NULL,
  `state` bit(1) NOT NULL DEFAULT b'0',
  `signOperatorId` int(11) DEFAULT NULL,
  `workOperatorId` int(11) DEFAULT NULL,
  `formId` int(11) NOT NULL,
  `isBeingEdited` bit(1) NOT NULL DEFAULT b'0',
  `signDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_tests_forms_clients_tests1_idx` (`clientTestId`),
  KEY `fk_tests_forms_forms1_idx` (`formId`),
  KEY `fk_tests_forms_signOperators_idx` (`signOperatorId`),
  KEY `fk_tests_forms_workOperators_idx` (`workOperatorId`),
  CONSTRAINT `fk_tests_forms_clients_tests1` FOREIGN KEY (`clientTestId`) REFERENCES `clients_tests` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tests_forms_forms1` FOREIGN KEY (`formId`) REFERENCES `forms` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tests_forms_operators1` FOREIGN KEY (`signOperatorId`) REFERENCES `operators` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tests_forms_operators2` FOREIGN KEY (`workOperatorId`) REFERENCES `operators` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=14108 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tests_forms_data`
--

DROP TABLE IF EXISTS `tests_forms_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tests_forms_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `testFormId` int(11) NOT NULL,
  `testFormData` longblob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_tests_forms_data_tests_forms1_idx` (`testFormId`),
  CONSTRAINT `fk_tests_forms_data_tests_forms1` FOREIGN KEY (`testFormId`) REFERENCES `tests_forms` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=14095 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2014-04-23 13:20:11
